//+------------------------------------------------------------------+
//|                                                Market Replay.mq5 |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Market Replay\C_Controls.mqh>
//+------------------------------------------------------------------+
C_Controls 	Control;
//+------------------------------------------------------------------+
int OnInit()
{
#define def_ShortName "Market Replay"
	u_Interprocess Info;
        
	IndicatorSetString(INDICATOR_SHORTNAME, def_ShortName);
	if (GlobalVariableCheck(def_GlobalVariableReplay))
	{
		Info.Value = GlobalVariableGet(def_GlobalVariableReplay);
		if (Info.s_Infos.IsUsing)
		{
			ChartIndicatorDelete(ChartID(), 0, def_ShortName);
			return INIT_FAILED;
		}
	} else Info.Value = 0;
	Control.Init(Info.s_Infos.isPlay);
        
	return INIT_SUCCEEDED;
#undef def_ShortName
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
	Control.DispatchMessage(id, lparam, dparam, sparam);
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	u_Interprocess Info;

	switch (reason)
	{
		case REASON_CHARTCHANGE:
			if (GlobalVariableCheck(def_GlobalVariableReplay))
			{
				Info.Value = GlobalVariableGet(def_GlobalVariableReplay);
				Info.s_Infos.IsUsing = false;
				GlobalVariableSet(def_GlobalVariableReplay, Info.Value);
			}
			break;
		case REASON_REMOVE:
		case REASON_CHARTCLOSE:
			GlobalVariableDel(def_GlobalVariableReplay);
			ChartClose(ChartID());
			break;
	}
}
//+------------------------------------------------------------------+
